
-- remember keys for Rigidbodies. only care about default PRS controller (especially Euler_XYZ and Potion_XYZ parts)
-- then we can reset scene exactly as beginning. and get simulation determinism

-- global varible for storing node keys
global gPxRBKeys = #()

struct pxNodeKeys
(
	inode,
	posTimes = #(),
	posx = #(),
	posy = #(),
	posz = #(),
	rotTimes = #(),
	rotx = #(),
	roty = #(),
	rotz = #(),

	fn Init =
	(
		posTimes = #()
		posx = #()
		posy = #()
		posz = #()
		rotTimes = #()
		rotx = #()
		roty = #()
		rotz = #()
	),
	
	fn SaveKeys=
	(
		-- clear old data
		Init()
		
		-- save Position keys
		if classof(inode.position.controller) == Position_XYZ then
		(
			c = inode.position.controller;
			for i = 1 to c.keys.count do 
			(
				t = c.keys[i].time
				append posTimes t
				at time t
				(
					append posx c.x_position
					append posy c.y_position
					append posz c.z_position
				)
			)
		)
		
		-- save Rotation keys
		if classof(inode.rotation.controller) == Euler_XYZ then
		(
			c = inode.rotation.controller;
			for i = 1 to c.keys.count do 
			(
				t = c.keys[i].time
				append rotTimes t
				at time t
				(
					append rotx c.x_rotation
					append roty c.y_rotation
					append rotz c.z_rotation
				)
			)
		)
	),
	
	fn ResetKeys =
	(
		with animate on
		(
			-- reset position keys
			c = inode.position.controller
			
			-- check controller type because it may be changed by some other codes
			if classof(c) == Position_XYZ then
			(
				for i = 1 to posTimes.count do
				(
					at time posTimes[i]
					(
						c.x_position = posx[i]
						c.y_position = posy[i]
						c.z_position = posz[i]
					)
				)
			)
			
			-- reset rotation keys
			c = inode.rotation.controller
			
			-- check controller type because it may be changed by some other codes
			if classof(c) == Euler_XYZ then
			(
				for i = 1 to rotTimes.count do
				(
					at time rotTimes[i]
					(
						c.x_rotation = rotx[i]
						c.y_rotation = roty[i]
						c.z_rotation = rotz[i]
					)
				)
			)
		)
	),
	
	-- use the following function to test before calling SaveKeys() and ResetKeys()
	fn HaveKeys pnode =
	(
		if pnode != undefined and superclassof(pnode.baseobject) == GeometryClass and classof(pnode.controller) == PRS then
		(
			pnode.position.controller.keys.count > 0 or pnode.rotation.controller.keys.count > 0
		)
		else
		(
			false
		)
	)
)


fn PxClearSavedRBKeys =
(
	gPxRBKeys = #()
)

fn PxSaveRBKeys pnode =
(
	if pxNodeKeys.HaveKeys(pnode) then
	(
		global PxGetModRB
		modRB = PxGetModRB pnode
		
		-- do not care about baked nodes
		if modRB != undefined and (modRB.baked == 0) then
		(
			newkeys = pxNodeKeys pnode
			append gPxRBKeys newkeys
			gPxRBKeys[gPxRBKeys.count].SaveKeys()
		)
	)
)

fn PxResetRBKeys =
(
	for i in gPxRBKeys do
	(
		if (IsValidNode(i) == true) do
			i.ResetKeys()
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB4dPv2OXFCMpM0YO/Pvy0vN+VK/GTa5S4K
-- /dOKNQSX/XWDwInBOZ88A6Ct/yLHEmtgSmbsRGHHdl8PFcpiiBEoRVUGtVdTYGQU
-- 5zSqDSOosf/MbbBA3cogai+DG/NFkiZjq06vluH5hn3s5+nLfdTa06p8zexLq2Kq
-- dywrFyjyqX9er5kP8m8KeM8FhjN4gLQRGW+qTuKYxw/a39HesOMSKZtIgnKKj+Z5
-- 1HyEdKBEtYWZylXzLxWip7kwqmg6YAroW2GNqDIyfksK5CbL+6QLjRzSEEPMthXm
-- 3umwz0IEifnMlCMLiD/nOo9QeC8ZT/iGB3OB89p4khWmLqb0wadY
-- -----END-SIGNATURE-----